﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CascadingDDL_MVC.Models;

namespace CascadingDDL_MVC.Controllers
{
	public class HomeController : Controller
	{

		private ProductDataEntitiesConn db = new ProductDataEntitiesConn();

		public ActionResult Index()
		{
			var ptypes = db.ProductTypes.OrderBy(p=>p.Name);
			ViewBag.ProductTypes = ptypes;
			return View();
		}

		[AcceptVerbs(HttpVerbs.Get)]
		public JsonResult LoadCategorys(string typeid)
		{
			if (string.IsNullOrEmpty(typeid))
				return Json(HttpNotFound());
			var categoryList = GetCategoryList(Convert.ToInt32(typeid));
			var categoryData = categoryList.Select(m => new SelectListItem()
			{
				Text = m.Name,
				Value = m.Id.ToString()
			});
			return Json(categoryData, JsonRequestBehavior.AllowGet);
		}

		private IList<ProductCategory> GetCategoryList(int typeid)
		{
			return db.ProductCategories.OrderBy(c => c.Name).Where(c => c.ProductTypeId == typeid).ToList();
		}

		public ActionResult GetProducts(string Id)
		{
			int id = Convert.ToInt32(Id);
			var products = db.Products.OrderBy(p => p.Name).Where(p => p.ProductCategoryId == id);
			return PartialView(products);

		}

		public ActionResult About()
		{
			ViewBag.Message = "Your app description page.";

			return View();
		}

		public ActionResult Contact()
		{
			ViewBag.Message = "Your contact page.";

			return View();
		}
	}
}
